#!C:/Programs/Strawberry/win64/perl/bin/perl.exe -I"."

####################################
# Simple LAN MP3 Player - Play MP3 #
####################################

use strict; use warnings;

use CGI;
use CGI::Carp "fatalsToBrowser";

my $cgi = new CGI;
print "Content-Type: text/html\n\n";
print '<!DOCTYPE html>', "\n\n";
my $app_dir = "C:/Programs/Apache24/htdocs";
# Get parameters from 'calling' webpage
my %params = $cgi->Vars;
my $dir = $params{'dir'};
$dir = 1 unless $dir;
my $file = $params{'file'}; $file =~ s/[\<\>\&\/\\"]//g;
$file =~ s/APOS/'/g; $file =~ s/AMP/&/g; $file =~ s/SCOL/;/g;
my $category = $params{'cat'}; $category =~ s/[^a-zA-Z\s]//g;
if ($file and $category and ($dir == 1 or $dir == 2)) {
  # Read template HTML file
  my $template;
  $template = "$app_dir/lan_mp3_player2.template.html";
  open(my $input, "<", $template)
    or die "Can't open template file $template: $!";
  my @lines = <$input>;
  close($input);
  # Create the webpage, printing the template, replacing all #-tags by the actual values
  foreach my $line (@lines) {
    chomp($line);
    if ($line) {
      if (substr($line, 0, 1) eq '#') {                                        # A '#' at beginning of line indicates that line contains a tag
        $line = substr($line, 1);
        if ($line =~ /#mp3file#/) {
          my $f = $file; $f =~ s/\.mp3//g; $f =~ s/;/:/g;
          $line =~ s/#mp3file#/$f/;
        }
        elsif ($line =~ /#dir##file#/) {
          my ($artist, $album, $track) = split(' - ', $file);
          my $media = '/media' . $dir . '/' . $category . '/';
          if ($track) {
            $media .= $artist . ' - ' . $album . '/';
          }
          $media .= $file;
          $line =~ s/#dir##file#/$media/;
        }
      }
      # Print file-line (with tags replaced) to webpage
      unless ($line =~ /#/) {
        print "$line\n";
      }
    }
  }
}
