#!C:/Programs/Strawberry/win64/perl/bin/perl.exe -I"."

######################################
# Simple LAN MP3 Player - Select MP3 #
######################################

use strict; use warnings;

use CGI;
use CGI::Carp "fatalsToBrowser";
use File::Find;
use MP3::Tag;


my $cgi = new CGI;
print "Content-Type: text/html\n\n";
print '<!DOCTYPE html>', "\n\n";
my $app_dir = "C:/Programs/Apache24/htdocs";
my @categories = (
  '', 'Classical', 'Electronic', 'International', 'Other', 'Pop', 'Progressive Rock', 'Rock', 'Special'
);
# Get parameters from 'calling' webpage
my %params = $cgi->Vars;
my $action = lc($params{'action'});
$action = 'init' unless ($action);
my $category; my @mp3paths; my @mp3files;
if ($action eq 'init' or $action eq 'search') {
  if ($action eq 'init') {
    $category = 1;
  }
  else {
    $category = $params{'category'};
    my @dirs = ("C:/Users/allu/Music/$categories[$category]", "E:/Music 2/$categories[$category]");
    find(\&mp3list, @dirs);
    my $dir; my $file;
    foreach my $path (@mp3paths) {
      if (substr($path, 0, 1) eq 'C') {
        $dir = 1;
      }
      else {
        $dir = 2;
      }
      $file = $path; $file =~ s/(.*\/)+//g; $file =~ s/'/APOS/g; $file =~ s/&/AMP/g; $file =~ s/;/SCOL/g;
      $file .= '--' . $path . '--' . $dir;
      push(@mp3files, $file);
    }
    @mp3files = sort {$a cmp $b} @mp3files;
  }
  # Read template HTML file
  my $template;
  $template = "$app_dir/lan_mp3_player1.template.html";
  open(my $input, "<", $template)
    or die "Can't open template file $template: $!";
  my @lines = <$input>;
  close($input);
  # Create the webpage, printing the template, replacing all #-tags by the actual values
  foreach my $line (@lines) {
    chomp($line);
    if ($line) {
      if (substr($line, 0, 1) eq '#') {                                        # A '#' at beginning of line indicates that line contains a tag
        $line = substr($line, 1);
        for (my $i = 1; $i <= 8; $i++) {
          my $sel = '#selected' . $i . '#';
              if ($line =~ /$sel/) {
            if ($i == $category) {
              $line =~ s/$sel/selected="selected"/;
            }
            else {
              $line =~ s/$sel//;
            }
          }
            }
          if ($line =~ /#table#/) {
          if ($action eq 'init') {
            $line =~ s/#table#//;
          }
          else {
            my $table;
            if (scalar @mp3files == 0) {
              $table = '<p>Sorry, no MP3 files found...</p>';
            }
            else {
              my @format = qw(=>s ?Hh ?{mL}m {SML}s);
              $table = '<table style="margin-top:15px" border="1">';
              $table .= '<tr>';
              $table .= '<th style="padding:5px">Artist</th>';
              $table .= '<th style="padding:5px">Album</th>';
              $table .= '<th style="padding:5px">Year</th>';
              $table .= '<th style="padding:5px">Track number and title</th>';
              $table .= '<th style="padding:5px">Duration</th>';
              $table .= '<th style="padding:5px">MP3 player</th>';
              $table .= '</tr>';
              foreach my $mp3file (@mp3files) {
                my ($file, $path, $dir) = split('--', $mp3file);
                my $mp3 = MP3::Tag->new($path);
                my ($title, $track, $artist, $album, $comment, $year, $genre) = $mp3->autoinfo();
                $table .= '<tr>';
                $table .= '<td style="padding:5px">' . $artist . '</td>';
                $table .= '<td style="padding:5px">' . $album . '</td>';
                $table .= '<td style="padding:5px">' . $year . '</td>';
                if ($track == 0) {
                  $table .= '<td style="padding:5px">&nbsp;</td>';
                }
                else {
                  $table .= '<td style="padding:5px">(' . sprintf('%02d', $track) . ') ' . $title . '</td>';
                }
                $table .= '<td style="padding:5px" align="right">' . $mp3->format_time($mp3->total_secs(), @format) . '</td>';
                if ($track == 0) {
                  $table .= '<td style="padding:5px"><a href="javascript:playmp3(' . $dir . ', ' . "'$categories[$category]'" . ', ' . "'$file'" . ')">play full album</a></td>';
                }
                else {
                  $table .= '<td style="padding:5px"><a href="javascript:playmp3(' . $dir . ', ' . "'$categories[$category]'" . ', ' . "'$file'" . ')">play this track</a></td>';
                }
                $table .= '</tr>';
              }
              $table .= '</table>';
            }
            $line =~ s/#table#/$table/;
          }
        }
      }
      # Print file-line (with tags replaced) to webpage
      unless ($line =~ /#/) {
        print "$line\n";
      }
    }
  }
}

# Subroutine for File::Find
# -------------------------

sub mp3list {
  my $file = $File::Find::name;
  return unless -f and $file =~ /(\.mp3)$/;
  push(@mp3paths, $file);
}
