segment code
..start:
        ; Initialization
        mov     ax, data
        mov     ds, ax
        mov     ax, stack
        mov     ss, ax
        mov     sp, stacktop
        ; Display text
        mov     dx, stext
        mov     ah, 09h
        int     21h
doloop:
        ; Wait for key pressed
        mov     ah, 10h
        int     16h
        ; Check if key pressed is ESC key
        cmp     al, keyesc
        je      exit
        ; Check if return is ASCII code or extended ASCII keystroke code
        cmp     al, 0
        je      extended
        ; Display ASCII code
        call    convert
        mov     [ascii], ax
        mov     dx, ascii
        mov     ah, 09h
        int     21h
        jmp     doloop
        ; Display extended ASCII keystroke code
extended:
        mov     al, ah
        call    convert
        mov     [ascii], ax
        mov     dx, extcode
        mov     ah, 09h
        int     21h
        jmp     doloop
        ; Terminate program
exit:
        mov     ax, 4c00h
        int     21h

; Convert positive integer (byte) to hexadecimal ASCII code
; ---------------------------------------------------------
; Input:  AL = byte; output: AX = byte ASCII codes
convert:
        push    bx
        push    cx
        mov     bl, al
        and     bl, 0fh                ; byte 4 LSB digits
        cmp     bl, 10
        jl      convert1
        sub     bl, 10
        add     bl, 'A'
        jmp     convert2
convert1:
        add     bl, '0'
convert2:
        mov     ch, bl
        mov     bl, al
        shr     bl, 4                  ; byte 4 MSB digits
        cmp     bl, 10
        jl      convert3
        sub     bl, 10
        add     bl, 'A'
        jmp     convert4
convert3:
        add     bl, '0'
convert4:
        mov     cl, bl
        mov     ax, cx
        pop     cx
        pop     bx
        ret

segment data
keyesc  equ     1bh
stext   db      'Hit a key (ESC to terminate) ', 13, 10, '$'
extcode db      '00 + '
ascii   resb    2
        db      13, 10, '$'

segment stack   stack
        resb    64
stacktop:
