;
; Program sample 4: Appending to file
;

; Main program
; ============
segment code
..start:
        ; Initialization
        ; --------------
        mov     ax, data
        mov     ds, ax
        mov     ax, stack
        mov     ss, ax
        mov     sp, stacktop
        ; Open file
        ; ---------
        mov     ah, 3dh
        mov     al, 2                            ; open file as read/write
        mov     dx, fname
        int     21h
        jc      file_error1
        mov     [handle], ax
        ; Set file position to end of file
        ; --------------------------------
        mov     ah, 42h
        mov     al, 2                            ; end of file position
        mov     bx, [handle]
        mov     cx, 0
        mov     dx, 0
        int     21h
        jc      file_error2
        ; Write insuline chain B to file
        ; -------------------------------
        mov     byte [count], lchainb            ; number of amino acids
        lea     esi, [chainb]                    ; pointer to the amino acids data
write_aa:
        lea     edi, [amacid]                    ; pointer to the copy destination
        mov     cl, 3                            ; 3-letter amino acid codes
        ; Copy this amino acid
copy_char:
        mov     bl, [esi]
        mov     [edi], bl
        inc     esi
        inc     edi
        dec     cl
        test    cl, cl
        jnz     copy_char
        ; Write this amino acid to file
        mov     ah, 40h
        mov     bx, [handle]
        mov     cx, 3
        mov     dx, amacid
        int     21h
        jc      file_error3
        ; Continue with next amino acid (unless all are done)
        mov     cl, [count]
        dec     cl
        mov     [count], cl
        test    cl, cl
        jnz     write_aa
        ; Set file position to beginning of file
        ; --------------------------------------
        mov     ah, 42h
        mov     al, 0                            ; begin of file position
        mov     bx, [handle]
        mov     cx, 0                            ; CX:DX = offset 0 from begin of file
        mov     dx, 0
        int     21h
        jc      file_error2
        ; Read insuline sequence from file, and display it
        ; ------------------------------------------------
        mov     ah, 3fh
        mov     bx, [handle]
        mov     cx, 3 * (lchaina + lchainb)
        mov     dx, chainab
        int     21h
        jc      file_error4
        mov     dx, chainab
        mov     ah, 09h
        int     21h
        jmp     done
        ; Open file error
        ; ---------------
file_error1:
        mov     dx, ferror1
        mov     ah, 09h
        int     21h
        jmp     exit
        ; Seek file error
        ; ----------------
file_error2:
        mov     dx, ferror2
        mov     ah, 09h
        int     21h
        jmp     done
        ; Write file error
        ; ----------------
file_error3:
        mov     dx, ferror3
        mov     ah, 09h
        int     21h
        jmp     done
        ; Read file error
        ; ---------------
file_error4:
        mov     dx, ferror4
        mov     ah, 09h
        int     21h
        jmp     done
        ; Close the file
        ; --------------
done:
        mov     bx, [handle]
        mov     ah, 3eh
        int     21h
        ; Terminate the program
        ; ---------------------
exit:
        mov     ax, 4c00h
        int     21h

; Data segment
; ============
segment data
lchaina equ     21
lchainb equ     30
chainb  db      'PHEVALASNGLNHISLEUCYSGLYSERHIS'
        db      'LEUVALGLUALALEUTYRLEUVALCYSGLY'
        db      'GLUARGGLYPHEPHETYRTHRPROLYSALA'
fname   db      'INSULINE.TXT', 00h
ferror1 db      'Error when opening file!', 13, 10, '$'
ferror2 db      'Error when setting file position!', 13, 10, '$'
ferror3 db      'Error when writing to file!', 13, 10, '$'
ferror4 db      'Error when reading from file!', 13, 10, '$'
handle  resb    2
amacid  resb    3
count   resb    1
chainab resb    3 * (lchaina + lchainb)
        db      13, 10, '$'

; Stack segment
; =============
segment stack   stack
        resb    64
stacktop:
