;
; Program sample 2: Write to file
;

; Main program
; ============
segment code
..start:
        ; Initialization
        ; --------------
        mov     ax, data
        mov     ds, ax
        mov     ax, stack
        mov     ss, ax
        mov     sp, stacktop
        ; Create a new file
        ; -----------------
        mov     ah, 3ch
        mov     cx, 0
        mov     dx, fname
        int     21h
        jc      file_error1
        mov     [handle], ax
        ; Write insuline chain A to the file
        ; ----------------------------------
        mov     byte [count], lchaina            ; number of amino acids
        lea     esi, [chaina]                    ; pointer to the amino acids data
write_aa:
        lea     edi, [amacid]                    ; pointer to the copy destination
        mov     cl, 3                            ; 3-letter amino acid codes
        ; Copy this amino acid
copy_char:
        mov     bl, [esi]
        mov     [edi], bl
        inc     esi
        inc     edi
        dec     cl
        test    cl, cl
        jnz     copy_char
        ; Write this amino acid to file
        mov     ah, 40h
        mov     bx, [handle]
        mov     cx, 3
        mov     dx, amacid
        int     21h
        jc      file_error2
        ; Continue with next amino acid (unless all are done)
        mov     cl, [count]
        dec     cl
        mov     [count], cl
        test    cl, cl
        jnz     write_aa
        ; Close the file
        ; --------------
        mov     bx, [handle]
        mov     ah, 3eh
        int     21h
        ; Display success message
        ; -----------------------
        mov     dx, success
        mov     ah, 09h
        int     21h
        jmp     exit
        ; Create file error
        ; -----------------
file_error1:
        mov     dx, ferror1
        mov     ah, 09h
        int     21h
        jmp     exit
        ; Write file error
        ; ----------------
file_error2:
        mov     dx, ferror2
        mov     ah, 09h
        int     21h
        jmp     exit
        ; Terminate the program
        ; ---------------------
exit:
        mov     ax, 4c00h
        int     21h

; Data segment
; ============
segment data
lchaina equ     21
chaina  db      'GLYILEVALGLUGLNCYSCYSTHRSERILE'
        db      'CYSSERLEUTYRGLNLEUGLUASNTYRCYS'
        db      'ASN'
fname   db      'INSULINE.TXT', 00h
success db      'File INSULINE.TXT successfully created!', 13, 10, '$'
ferror1 db      'Error when creating file!', 13, 10, '$'
ferror2 db      'Error when writing to file!', 13, 10, '$'
handle  resb    2
amacid  resb    3
count   resb    1

; Stack segment
; =============
segment stack   stack
        resb    64
stacktop:
