program mp3a;

{$mode objfpc}{$H+}

uses
  SysUtils, ID3v2;

var
  FName, Title, Artist, Album, Genre, Year, Track: string;

{ Read MP3 tags (using the ID3v2 unit) }

procedure ReadMP3Tags(var MP3File: string; out STitle, SArtist, SAlbum, SGenre, SYear, STrack: string);

 var
   MP3Tags: TID3v2;
begin
   MP3Tags := TID3v2.Create;
   try
     with MP3Tags do begin
       ReadFromFile(MP3File);
       STitle := Title;
       SArtist := Artist;
       SAlbum := Album;
       SYear := Year;
       SGenre := Genre;
       STrack := IntToStr(Track);
     end;
   finally
     MP3Tags.Free;
   end;
end;

begin
  repeat
    Writeln; Write('Enter filename? '); Readln(FName);
    if FName <> '' then begin
      ReadMP3Tags(FName, Title, Artist, Album, Genre, Year, Track);
      Writeln('  ', Album, ' by ', Artist, ' (released in ', Year, '):');
      Writeln('  Music genre = ', Genre);
      Writeln('  Track title = ', Track, '. ', Title);
    end;
  until FName = '';
  Writeln;
end.

