{************************************}
{* Main unit for Oracle application *}
{************************************}

unit oracle_main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, mysql57conn, sqldb, oracleconnection, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls, Grids;

type
  {**********}
  { TfOracle }
  {**********}
  TfOracle = class(TForm)
    StaticText1: TStaticText;
    sgEmployees: TStringGrid;
    laCountry: TLabel;
    edMess: TEdit;
    btQuery: TButton;
    btExit: TButton;
    dbSQLTransaction: TSQLTransaction;
    dbOracleConnection: TOracleConnection;
    dbSQLQuery: TSQLQuery;
    procedure FormCreate(Sender: TObject);
    procedure btQueryClick(Sender: TObject);
    procedure btExitClick(Sender: TObject);
  end;

var
  fOracle: TfOracle;

implementation

{$R *.lfm}

{**********}
{ TfOracle }
{**********}

{ Application start: Connect to the database }

procedure TfOracle.FormCreate(Sender: TObject);

begin
  if dbOracleConnection.Connected then                                         // close (open) database connection
    dbOracleConnection.Close;
  // Set the connection parameters.
  dbOracleConnection.HostName := 'localhost';
  dbOracleConnection.UserName := 'aly';
  dbOracleConnection.Password := 'oracle';
  dbOracleConnection.DatabaseName := 'FREEPDB1';
  // Connect to the database
  try
    dbOracleConnection.Open;
    edMess.Color := clDefault;
    edMess.Text  := 'Connected to Oracle SAMPLE database';
  except
    on E: ESQLDatabaseError do begin
      edMess.Color := clRed;
      edMess.Text := E.Message;
    end;
  end;
end;

{ Button "Query": Read accountant employees from the "employees" table }

procedure TfOracle.btQueryClick(Sender: TObject);

var
  Count: Integer;
  Query: string;

begin
  if dbOracleConnection.Connected then begin
    sgEmployees.Clean(0, 1, 2, 8, []);
    // Create query
    Query := 'SELECT last_name AS LName, first_name AS FName, job_title AS Job FROM employees ';
    Query += 'WHERE job_title LIKE ''%Account%'' ';
    Query += 'ORDER BY last_name, first_name';
    // Query the database
    dbSQLQuery.SQL.Text := Query; Count := 0;
    try
      dbSQLQuery.Open;                                                         // start the query
      dbSQLQuery.First;                                                        // read first record of query result set
      while not dbSQLQuery.EOF do begin                                        // while not all records done, execute this loop
        Inc(Count);
        sgEmployees.Cells[0, Count] := dbSQLQuery.FieldByName('LName').AsString;
        sgEmployees.Cells[1, Count] := dbSQLQuery.FieldByName('FName').AsString;
        sgEmployees.Cells[2, Count] := dbSQLQuery.FieldByName('Job').AsString;
        dbSQLQuery.Next;                                                       // read next record of query result set
      end;                                                                     // end the query
      dbSQLQuery.Close;
      // Display count of employees
      if Count = 0 then
        edMess.Text := 'No employees found in database!'
      else
        edMess.Text := 'Number of accounting employees in database = ' + IntToStr(Count);
      edMess.Color := clDefault;
    except
      on E: ESQLDatabaseError do begin
        edMess.Text := E.Message;
        edMess.Color := clRed;
      end;
    end;
  end;
end;

{ Button "Exit": Close database connection and exit application }

procedure TfOracle.btExitClick(Sender: TObject);

begin
  if dbOracleConnection.Connected then                                         // close database connection
    dbOracleConnection.Close;
  Close;
end;

end.

