{****************************************}
{* Main unit for "Japanese" application *}
{****************************************}

unit jap;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, StdCtrls, Menus, Grids, LazUTF8;

type
  TScriptItem = record
    Syllable, Pronunciation: string;
    Double, Extended: Boolean;
  end;
  TScript = array of TScriptItem;
  {************}
  { TfJapanese }
  {************}
  TfJapanese = class(TForm)
    mMenu: TMainMenu;
    mTest, mTestP, mTestW, mTestExit: TMenuItem;
    mHelp, mHelpHelp, mHelpAbout: TMenuItem;
    StaticText1: TStaticText;
    rbHiragana, rbKatakana: TRadioButton;
    cbExtended: TCheckBox;
    Label1, laGiven, laFind: TLabel;
    edGiven, edFind, edEval: TEdit;
    sgEval: TStringGrid;
    bt1, bt2, bt3, bt4, bt5, bt6, bt7, bt8, bt9, bt10: TButton;
    bt11, bt12, bt13, bt14, bt15, bt16, bt17, bt18, bt19, bt20: TButton;
    bt21, bt22, bt23, bt24, bt25, bt26, bt27, bt28, bt29, bt30: TButton;
    bt31, bt32, bt33, bt34, bt35, bt36, bt37, bt38, bt39, bt40: TButton;
    bt41, bt42, bt43, bt44, bt45, bt46, bt47, bt48, bt49, bt50: TButton;
    bt51, bt52, bt53, bt54, bt55, bt56, bt57, bt58, bt59, bt60: TButton;
    bt61, bt62, bt63, bt64, bt65, bt66, bt67, bt68, bt69, bt70: TButton;
    bt71, bt72, bt73, bt74, bt75, bt76, bt77, bt78, bt79, bt80: TButton;
    btAction: TButton;
    btReset: TButton;
    procedure FormCreate(Sender: TObject);
    procedure mTestPClick(Sender: TObject);
    procedure mTestWClick(Sender: TObject);
    procedure mTestExitClick(Sender: TObject);
    procedure mHelpHelpClick(Sender: TObject);
    procedure mHelpAboutClick(Sender: TObject);
    procedure btActionClick(Sender: TObject);
    procedure btResetClick(Sender: TObject);
    procedure bt1Click(Sender: TObject);
    procedure bt2Click(Sender: TObject);
    procedure bt3Click(Sender: TObject);
    procedure bt4Click(Sender: TObject);
    procedure bt5Click(Sender: TObject);
    procedure bt6Click(Sender: TObject);
    procedure bt7Click(Sender: TObject);
    procedure bt8Click(Sender: TObject);
    procedure bt9Click(Sender: TObject);
    procedure bt10Click(Sender: TObject);
    procedure bt11Click(Sender: TObject);
    procedure bt12Click(Sender: TObject);
    procedure bt13Click(Sender: TObject);
    procedure bt14Click(Sender: TObject);
    procedure bt15Click(Sender: TObject);
    procedure bt16Click(Sender: TObject);
    procedure bt17Click(Sender: TObject);
    procedure bt18Click(Sender: TObject);
    procedure bt19Click(Sender: TObject);
    procedure bt20Click(Sender: TObject);
    procedure bt21Click(Sender: TObject);
    procedure bt22Click(Sender: TObject);
    procedure bt23Click(Sender: TObject);
    procedure bt24Click(Sender: TObject);
    procedure bt25Click(Sender: TObject);
    procedure bt26Click(Sender: TObject);
    procedure bt27Click(Sender: TObject);
    procedure bt28Click(Sender: TObject);
    procedure bt29Click(Sender: TObject);
    procedure bt30Click(Sender: TObject);
    procedure bt31Click(Sender: TObject);
    procedure bt32Click(Sender: TObject);
    procedure bt33Click(Sender: TObject);
    procedure bt34Click(Sender: TObject);
    procedure bt35Click(Sender: TObject);
    procedure bt36Click(Sender: TObject);
    procedure bt37Click(Sender: TObject);
    procedure bt38Click(Sender: TObject);
    procedure bt39Click(Sender: TObject);
    procedure bt40Click(Sender: TObject);
    procedure bt41Click(Sender: TObject);
    procedure bt42Click(Sender: TObject);
    procedure bt43Click(Sender: TObject);
    procedure bt44Click(Sender: TObject);
    procedure bt45Click(Sender: TObject);
    procedure bt46Click(Sender: TObject);
    procedure bt47Click(Sender: TObject);
    procedure bt48Click(Sender: TObject);
    procedure bt49Click(Sender: TObject);
    procedure bt50Click(Sender: TObject);
    procedure bt51Click(Sender: TObject);
    procedure bt52Click(Sender: TObject);
    procedure bt53Click(Sender: TObject);
    procedure bt54Click(Sender: TObject);
    procedure bt55Click(Sender: TObject);
    procedure bt56Click(Sender: TObject);
    procedure bt57Click(Sender: TObject);
    procedure bt58Click(Sender: TObject);
    procedure bt59Click(Sender: TObject);
    procedure bt60Click(Sender: TObject);
    procedure bt61Click(Sender: TObject);
    procedure bt62Click(Sender: TObject);
    procedure bt63Click(Sender: TObject);
    procedure bt64Click(Sender: TObject);
    procedure bt65Click(Sender: TObject);
    procedure bt66Click(Sender: TObject);
    procedure bt67Click(Sender: TObject);
    procedure bt68Click(Sender: TObject);
    procedure bt69Click(Sender: TObject);
    procedure bt70Click(Sender: TObject);
    procedure bt71Click(Sender: TObject);
    procedure bt72Click(Sender: TObject);
    procedure bt73Click(Sender: TObject);
    procedure bt74Click(Sender: TObject);
    procedure bt75Click(Sender: TObject);
    procedure bt76Click(Sender: TObject);
    procedure bt77Click(Sender: TObject);
    procedure bt78Click(Sender: TObject);
    procedure bt79Click(Sender: TObject);
    procedure bt80Click(Sender: TObject);
    procedure rbKatakanaChange(Sender: TObject);
  private
    iItems, iQuestions, iQuestion, iCorrect: Integer;
    sTest, sAnswer1, sAnswer2, sUserAnswer: string;
    bDone: array of Boolean;
    btChars: array[0..79] of TButton;
    aHiragana, aKatakana, aScript: TScript;
  end;

var
  fJapanese: TfJapanese;

implementation

{$R *.lfm}

{ Format number for the grid (right-align) }

function GFormat(N: Integer; S: string): string;

var
  FN: string;

begin
  FN := ' ';
  if N < 10 then
    FN += '  '
  else if N < 100 then
    FN += ' ';
  FN += IntToStr(N);
  FN += S;
  Result := FN;
end;

{ Read scripts data from text files }

procedure ReadScripts(out Hiragana, Katakana: TScript);

var
  N: Integer;
  Line: string;
  InFile: Text;

begin
  // Hiragana script data
  Assign(InFile, 'hiragana.txt'); Reset(InFile);
  N := 0;
  while not EoF(Infile) do begin
    Readln(InFile, Line); UTF8Trim(Line);
    if Line <> '' then begin
      Inc(N); SetLength(Hiragana, N);
      with Hiragana[N - 1] do begin
        Syllable := UTF8Trim(UTF8Copy(Line, 5, 2));
        Pronunciation := UTF8Trim(UTF8Copy(Line, 1, 3));
        Double := False; Extended := False;
        if UTF8Length(Line) > 6 then begin
          if UTF8Copy(Line, 8, 1) = '*' then
            Double := True;
        end;
      end;
    end;
  end;
  Close(InFile);
  // Katakana script data
  Assign(InFile, 'katakana.txt'); Reset(InFile);
  N := 0;
  while not EoF(Infile) do begin
    Readln(InFile, Line); UTF8Trim(Line);
    if Line <> '' then begin
      Inc(N); SetLength(Katakana, N);
      with Katakana[N - 1] do begin
        Syllable := UTF8Trim(UTF8Copy(Line, 5, 2));
        Pronunciation := UTF8Trim(UTF8Copy(Line, 1, 3));
        Double := False; Extended := False;
        if UTF8Length(Line) > 6 then begin
          if UTF8Copy(Line, 8, 1) = '*' then
            Double := True;
          if UTF8Copy(Line, 8, 1) = '+' then
            Extended := True;
        end;
      end;
    end;
  end;
  Close(InFile);
end;

{ Prepare for a new test }

function NewTest(Test: string; var Hiragana, Katakana: TScript): Integer;

// The function returns the number of script characters
// (normally 71, 80 for Katakana with extended characters enabled)

var
  N, I, J: Integer;
  Double1, Double2: string;
  Script: TScript;

begin
  if Test = 'pronunciation' then begin
    fJapanese.laGiven.Caption := 'Syllable'; fJapanese.laFind.Caption := 'Pronunciation';
    fJapanese.edGiven.Left := fJapanese.laGiven.Left + 65; fJapanese.edFind.Left := fJapanese.laFind.Left + 115;
  end
  else begin
    fJapanese.laGiven.Caption := 'Pronunciation'; fJapanese.laFind.Caption := 'Syllable';
    fJapanese.edGiven.Left := fJapanese.laGiven.Left + 115; fJapanese.edFind.Left := fJapanese.laFind.Left + 65;
  end;
  N := 71;
  for I := 72 to 80 do
    fJapanese.btChars[I - 1].Visible := False;
  if fJapanese.rbHiragana.Checked then begin
    Script := Hiragana;
  end
  else begin
    if fJapanese.cbExtended.Checked then
      N := 80;
    Script := Katakana;
  end;
  for I := 70 to N do
    fJapanese.btChars[I - 1].Visible := True;
  // Set button captions to Hiragana or Katakana syllables
  if Test = 'write' then begin
    for I := 1 to N do begin
      fJapanese.btChars[I - 1].Caption := Script[I - 1].Syllable;
    end;
    fJapanese.btChars[N - 1].Visible := True; fJapanese.btChars[N - 2].Visible := True;
  end
  // Set button captions to pronunciation sounds
  else begin
    // As the sounds "ji" and "zu" appear twice, we have to ignore their second occurrence
    Double1 := ''; Double2 := '';
    J := 0;
    for I := 1 to N do begin
      if (not Script[I - 1].Double) or ((Script[I - 1].Pronunciation <> Double1) and (Script[I - 1].Pronunciation <> Double2)) then begin
        Inc(J);
        fJapanese.btChars[J - 1].Caption := Script[I - 1].Pronunciation;
      end;
      if (Script[I - 1].Double) then begin
        if Double1 = '' then
          Double1 := Script[I - 1].Pronunciation
        else if Double1 <> Script[I - 1].Pronunciation then
          Double2 := Script[I - 1].Pronunciation;
      end;
    end;
    fJapanese.btChars[N - 1].Visible := False; fJapanese.btChars[N - 2].Visible := False;
  end;
  fJapanese.edGiven.Text := ''; fJapanese.edFind.Text := '';
  for I := 0 to 3 do
    fJapanese.sgEval.Cells[1, I] := '';
  fJapanese.edEval.Text := '';
  fJapanese.btAction.Caption := 'Start';
  fJapanese.btAction.Enabled := True;
  fJapanese.btReset.Enabled := False;
  Result := N;
end;

{ Get user answer (syllable/sound button pressed) }

function UserInput(Button: Integer): string;

var
  Answer: string;

begin
  Answer := fJapanese.btChars[Button - 1].Caption;
  fJapanese.edFind.Text := Answer;
  Result := Answer;
end;

{************}
{ TfJapanese }
{************}

{ Application start: Initialization }

procedure TfJapanese.FormCreate(Sender: TObject);

begin
  btChars[0]  := bt1;  btChars[1]  := bt2;  btChars[2]  := bt3;  btChars[3]  := bt4;  btChars[4]  := bt5;
  btChars[5]  := bt6;  btChars[6]  := bt7;  btChars[7]  := bt8;  btChars[8]  := bt9;  btChars[9]  := bt10;
  btChars[10] := bt11; btChars[11] := bt12; btChars[12] := bt13; btChars[13] := bt14; btChars[14] := bt15;
  btChars[15] := bt16; btChars[16] := bt17; btChars[17] := bt18; btChars[18] := bt19; btChars[19] := bt20;
  btChars[20] := bt21; btChars[21] := bt22; btChars[22] := bt23; btChars[23] := bt24; btChars[24] := bt25;
  btChars[25] := bt26; btChars[26] := bt27; btChars[27] := bt28; btChars[28] := bt29; btChars[29] := bt30;
  btChars[30] := bt31; btChars[31] := bt32; btChars[32] := bt33; btChars[33] := bt34; btChars[34] := bt35;
  btChars[35] := bt36; btChars[36] := bt37; btChars[37] := bt38; btChars[38] := bt39; btChars[39] := bt40;
  btChars[40] := bt41; btChars[41] := bt42; btChars[42] := bt43; btChars[43] := bt44; btChars[44] := bt45;
  btChars[45] := bt46; btChars[46] := bt47; btChars[47] := bt48; btChars[48] := bt49; btChars[49] := bt50;
  btChars[50] := bt51; btChars[51] := bt52; btChars[52] := bt53; btChars[53] := bt54; btChars[54] := bt55;
  btChars[55] := bt56; btChars[56] := bt57; btChars[57] := bt58; btChars[58] := bt59; btChars[59] := bt60;
  btChars[60] := bt61; btChars[61] := bt62; btChars[62] := bt63; btChars[63] := bt64; btChars[64] := bt65;
  btChars[65] := bt66; btChars[66] := bt67; btChars[67] := bt68; btChars[68] := bt69; btChars[69] := bt70;
  btChars[70] := bt71; btChars[71] := bt72; btChars[72] := bt73; btChars[73] := bt74; btChars[74] := bt75;
  btChars[75] := bt76; btChars[76] := bt77; btChars[77] := bt78; btChars[78] := bt79; btChars[79] := bt80;
  ReadScripts(aHiragana, aKatakana);
  Randomize;
  iQuestions := 20;
  fJapanese.mTestP.Click;                                  // start with pronunciation test
end;

{ Menu item "Test > Pronunciation test": Start a new pronunciation test }

procedure TfJapanese.mTestPClick(Sender: TObject);

begin
  sTest := 'pronunciation';
  iItems := NewTest(sTest, aHiragana, aKatakana);
end;

{ Menu item "Test > Writing test": Start a new writing test }

procedure TfJapanese.mTestWClick(Sender: TObject);

begin
  sTest := 'write';
  iItems := NewTest(sTest, aHiragana, aKatakana);
end;

{ Menu item "Test > Exit": Exit application }

procedure TfJapanese.mTestExitClick(Sender: TObject);

begin
  Close;
end;

{ Menu item "Help > Help": Display (short) application help }

procedure TfJapanese.mHelpHelpClick(Sender: TObject);

var
  S: string;

begin
  S := 'The application includes both finding how a given syllable is pronounced, and how a given sound is written. ';
  S += 'The script used (Hiragana or Katakana) is selected via the radio buttons. Push "Start" to begin the test, ';
  S += '"Question" to display the next question, "Answer" to let check your answer. The number of questions is set to ';
  S += '20. You can quit a test, using the "Reset" button.';
  MessageDlg('"Japanese" help', S, mtInformation, [mbOK], 0);
end;

{ Menu item "Help > About": Display application about }

procedure TfJapanese.mHelpAboutClick(Sender: TObject);

var
  S: string;

begin
  S := 'Japanese writing system.' + LineEnding;
  S += 'Learn the Japanese Hiragana and Katakana scripts.' + LineEnding + LineEnding;
  S += 'Version 1.0, © allu, November 2025.';
  MessageDlg('About "Japanese"', S, mtInformation, [mbOK], 0);
end;

{ Button "Start/Question/Answer" pushed: Generate new question resp. check user answer }

procedure TfJapanese.btActionClick(Sender: TObject);

var
  N, I: Integer;
  OK: Boolean;

begin
  // Button "Start/Question" pushed: Generate new question
  if (btAction.Caption = 'Start') or (btAction.Caption = 'Question') then begin
    // Button "Start" pushed: Some initializations to be done before generating the first question
    if btAction.Caption = 'Start' then begin
      iQuestion := 0; iCorrect := 0;
      SetLength(bDone, iItems);
      if rbHiragana.Checked then
        aScript := aHiragana
      else
        aScript := aKatakana;
      for I := 0 to iItems - 1 do
        bDone[I] := False;
      rbHiragana.Enabled := False; rbKatakana.Enabled := False; cbExtended.Enabled := False;
      btReset.Enabled := True;
    end;
    // Generate question
    Inc(iQuestion);
    OK := False;
    repeat
      N := Random(iItems);
      if not bDone[N] then begin
        bDone[N] := True;
        if sTest = 'write' then begin
          // Make sure that "ji" and "zu" are asked only once
          if aScript[N].Double then begin
            if N = 51 then
              bDone[56] := True
            else if N = 52 then
              bDone[57] := True
            else if N = 56 then
              bDone[51] := True
            else if N = 57 then
              bDone[52] := True
          end;
        end;
        OK := True;
      end;
    until OK;
    if sTest = 'pronunciation' then begin
      // Pronunciation test
      edGiven.Text := aScript[N].Syllable; edFind.Text := ''; edFind.SetFocus;
      sAnswer1 := aScript[N].Pronunciation;
      sAnswer2 := sAnswer1;
    end
    else begin
      // Writing test
      edGiven.Text := aScript[N].Pronunciation; edFind.Text := ''; edFind.SetFocus;
      sAnswer1 := aScript[N].Syllable;
      sAnswer2 := sAnswer1;
      if aScript[N].Double then begin
        // For the sounds "ji" and "zu", there are two correct answers
        if N = 51 then
          sAnswer2 := aScript[56].Syllable
        else if N = 52 then
          sAnswer2 := aScript[57].Syllable
        else if N = 56 then
          sAnswer2 := aScript[51].Syllable
        else if N = 57 then
          sAnswer2 := aScript[52].Syllable;
      end;
    end;
    // Next button push will be for checking user answer
    edEval.Text := '';
    btAction.Caption := 'Answer';
  end
  { Button "Answer" pushed: Check user answer }
  else begin
    if (sUserAnswer = sAnswer1) or (sUserAnswer = sAnswer2) then begin
      Inc(iCorrect);
      edEval.Font.Color := clDefault;
      edEval.Text := 'This is correct.';
    end
    else begin
      edEval.Font.Color := clRed;
      edEval.Text := 'Bad answer!';
    end;
    // Fill in the evaluation grid
    sgEval.Cells[1, 0] := GFormat(iQuestion, '');
    sgEval.Cells[1, 1] := GFormat(iCorrect, '');
    sgEval.Cells[1, 2] := GFormat(iQuestion - iCorrect, '');
    sgEval.Cells[1, 3] := GFormat(Round(100 * (iCorrect / iQuestion)), '%');
    if iQuestion = iQuestions then begin
      // All 20 questions done: End of test
      rbHiragana.Enabled := True; rbKatakana.Enabled := True;
      if rbKatakana.Checked then
        cbExtended.Enabled := True;
      btReset.Enabled := False;
      btAction.Caption := 'Start';
      btAction.Enabled := False;                           // User must choose an item from the "Test" menu to continue
      MessageDlg('Japanese writing system', 'All questions done. End of test.', mtInformation, [mbOK], 0);
    end
    else begin
      // Next button push will be for a new question
      btAction.Caption := 'Question';
      btAction.SetFocus;
    end;
  end;
end;

{ Button "Reset" pushed: Terminate the actual test }

procedure TfJapanese.btResetClick(Sender: TObject);

begin
  rbHiragana.Enabled := True; rbKatakana.Enabled := True;
  if rbKatakana.Checked then
    cbExtended.Enabled := True;
  btReset.Enabled := False;
  btAction.Caption := 'Start';
  btAction.Enabled := False;                               // User must choose an item from the "Test" menu to continue
  MessageDlg('Japanese writing system', 'Test terminated by user...', mtInformation, [mbOK], 0);
end;

{ Syllable/sound buttons pushed: Get user answer }

procedure TfJapanese.bt1Click(Sender: TObject);

begin
  sUserAnswer := UserInput(1);
end;

procedure TfJapanese.bt2Click(Sender: TObject);

begin
  sUserAnswer := UserInput(2);
end;

procedure TfJapanese.bt3Click(Sender: TObject);

begin
  sUserAnswer := UserInput(3);
end;

procedure TfJapanese.bt4Click(Sender: TObject);

begin
  sUserAnswer := UserInput(4);
end;

procedure TfJapanese.bt5Click(Sender: TObject);

begin
    sUserAnswer := UserInput(5);
end;

procedure TfJapanese.bt6Click(Sender: TObject);

begin
  sUserAnswer := UserInput(6);
end;

procedure TfJapanese.bt7Click(Sender: TObject);

begin
  sUserAnswer := UserInput(7);
end;

procedure TfJapanese.bt8Click(Sender: TObject);

begin
  sUserAnswer := UserInput(8);
end;

procedure TfJapanese.bt9Click(Sender: TObject);

begin
  sUserAnswer := UserInput(9);
end;

procedure TfJapanese.bt10Click(Sender: TObject);

begin
  sUserAnswer := UserInput(10);
end;

procedure TfJapanese.bt11Click(Sender: TObject);

begin
  sUserAnswer := UserInput(11);
end;

procedure TfJapanese.bt12Click(Sender: TObject);

begin
  sUserAnswer := UserInput(12);
end;

procedure TfJapanese.bt13Click(Sender: TObject);

begin
  sUserAnswer := UserInput(13);
end;

procedure TfJapanese.bt14Click(Sender: TObject);

begin
  sUserAnswer := UserInput(14);
end;

procedure TfJapanese.bt15Click(Sender: TObject);

begin
  sUserAnswer := UserInput(15);
end;

procedure TfJapanese.bt16Click(Sender: TObject);

begin
  sUserAnswer := UserInput(16);
end;

procedure TfJapanese.bt17Click(Sender: TObject);

begin
  sUserAnswer := UserInput(17);
end;

procedure TfJapanese.bt18Click(Sender: TObject);

begin
  sUserAnswer := UserInput(18);
end;

procedure TfJapanese.bt19Click(Sender: TObject);

begin
  sUserAnswer := UserInput(19);
end;

procedure TfJapanese.bt20Click(Sender: TObject);

begin
  sUserAnswer := UserInput(20);
end;

procedure TfJapanese.bt21Click(Sender: TObject);

begin
  sUserAnswer := UserInput(21);
end;

procedure TfJapanese.bt22Click(Sender: TObject);

begin
  sUserAnswer := UserInput(22);
end;

procedure TfJapanese.bt23Click(Sender: TObject);

begin
  sUserAnswer := UserInput(23);
end;

procedure TfJapanese.bt24Click(Sender: TObject);

begin
  sUserAnswer := UserInput(24);
end;

procedure TfJapanese.bt25Click(Sender: TObject);

begin
  sUserAnswer := UserInput(25);
end;

procedure TfJapanese.bt26Click(Sender: TObject);

begin
  sUserAnswer := UserInput(26);
end;

procedure TfJapanese.bt27Click(Sender: TObject);

begin
  sUserAnswer := UserInput(27);
end;

procedure TfJapanese.bt28Click(Sender: TObject);

begin
  sUserAnswer := UserInput(28);
end;

procedure TfJapanese.bt29Click(Sender: TObject);

begin
  sUserAnswer := UserInput(29);
end;

procedure TfJapanese.bt30Click(Sender: TObject);

begin
  sUserAnswer := UserInput(30);
end;

procedure TfJapanese.bt31Click(Sender: TObject);

begin
  sUserAnswer := UserInput(31);
end;

procedure TfJapanese.bt32Click(Sender: TObject);

begin
  sUserAnswer := UserInput(32);
end;

procedure TfJapanese.bt33Click(Sender: TObject);

begin
  sUserAnswer := UserInput(33);
end;

procedure TfJapanese.bt34Click(Sender: TObject);

begin
  sUserAnswer := UserInput(34);
end;

procedure TfJapanese.bt35Click(Sender: TObject);

begin
  sUserAnswer := UserInput(35);
end;

procedure TfJapanese.bt36Click(Sender: TObject);

begin
  sUserAnswer := UserInput(36);
end;

procedure TfJapanese.bt37Click(Sender: TObject);

begin
  sUserAnswer := UserInput(37);
end;

procedure TfJapanese.bt38Click(Sender: TObject);

begin
  sUserAnswer := UserInput(38);
end;

procedure TfJapanese.bt39Click(Sender: TObject);

begin
  sUserAnswer := UserInput(39);
end;

procedure TfJapanese.bt40Click(Sender: TObject);

begin
  sUserAnswer := UserInput(40);
end;

procedure TfJapanese.bt41Click(Sender: TObject);

begin
  sUserAnswer := UserInput(41);
end;

procedure TfJapanese.bt42Click(Sender: TObject);

begin
  sUserAnswer := UserInput(42);
end;

procedure TfJapanese.bt43Click(Sender: TObject);

begin
  sUserAnswer := UserInput(43);
end;

procedure TfJapanese.bt44Click(Sender: TObject);

begin
  sUserAnswer := UserInput(44);
end;

procedure TfJapanese.bt45Click(Sender: TObject);

begin
  sUserAnswer := UserInput(45);
end;

procedure TfJapanese.bt46Click(Sender: TObject);

begin
  sUserAnswer := UserInput(46);
end;

procedure TfJapanese.bt47Click(Sender: TObject);

begin
  sUserAnswer := UserInput(47);
end;

procedure TfJapanese.bt48Click(Sender: TObject);

begin
  sUserAnswer := UserInput(48);
end;

procedure TfJapanese.bt49Click(Sender: TObject);

begin
  sUserAnswer := UserInput(49);
end;

procedure TfJapanese.bt50Click(Sender: TObject);

begin
  sUserAnswer := UserInput(50);
end;

procedure TfJapanese.bt51Click(Sender: TObject);

begin
  sUserAnswer := UserInput(51);
end;

procedure TfJapanese.bt52Click(Sender: TObject);

begin
  sUserAnswer := UserInput(52);
end;

procedure TfJapanese.bt53Click(Sender: TObject);

begin
  sUserAnswer := UserInput(53);
end;

procedure TfJapanese.bt54Click(Sender: TObject);

begin
  sUserAnswer := UserInput(54);
end;

procedure TfJapanese.bt55Click(Sender: TObject);

begin
  sUserAnswer := UserInput(55);
end;

procedure TfJapanese.bt56Click(Sender: TObject);

begin
  sUserAnswer := UserInput(56);
end;

procedure TfJapanese.bt57Click(Sender: TObject);

begin
  sUserAnswer := UserInput(57);
end;

procedure TfJapanese.bt58Click(Sender: TObject);

begin
  sUserAnswer := UserInput(58);
end;

procedure TfJapanese.bt59Click(Sender: TObject);

begin
  sUserAnswer := UserInput(59);
end;

procedure TfJapanese.bt60Click(Sender: TObject);

begin
  sUserAnswer := UserInput(60);
end;

procedure TfJapanese.bt61Click(Sender: TObject);

begin
  sUserAnswer := UserInput(61);
end;

procedure TfJapanese.bt62Click(Sender: TObject);

begin
  sUserAnswer := UserInput(62);
end;

procedure TfJapanese.bt63Click(Sender: TObject);

begin
  sUserAnswer := UserInput(63);
end;

procedure TfJapanese.bt64Click(Sender: TObject);

begin
  sUserAnswer := UserInput(64);
end;

procedure TfJapanese.bt65Click(Sender: TObject);

begin
  sUserAnswer := UserInput(65);
end;

procedure TfJapanese.bt66Click(Sender: TObject);

begin
  sUserAnswer := UserInput(66);
end;

procedure TfJapanese.bt67Click(Sender: TObject);

begin
  sUserAnswer := UserInput(67);
end;

procedure TfJapanese.bt68Click(Sender: TObject);

begin
  sUserAnswer := UserInput(68);
end;

procedure TfJapanese.bt69Click(Sender: TObject);

begin
  sUserAnswer := UserInput(69);
end;

procedure TfJapanese.bt70Click(Sender: TObject);

begin
  sUserAnswer := UserInput(70);
end;

procedure TfJapanese.bt71Click(Sender: TObject);

begin
  sUserAnswer := UserInput(71);
end;

procedure TfJapanese.bt72Click(Sender: TObject);

begin
  sUserAnswer := UserInput(72);
end;

procedure TfJapanese.bt73Click(Sender: TObject);

begin
  sUserAnswer := UserInput(73);
end;

procedure TfJapanese.bt74Click(Sender: TObject);

begin
  sUserAnswer := UserInput(74);
end;

procedure TfJapanese.bt75Click(Sender: TObject);

begin
  sUserAnswer := UserInput(75);
end;

procedure TfJapanese.bt76Click(Sender: TObject);

begin
  sUserAnswer := UserInput(76);
end;

procedure TfJapanese.bt77Click(Sender: TObject);

begin
  sUserAnswer := UserInput(77);
end;

procedure TfJapanese.bt78Click(Sender: TObject);

begin
  sUserAnswer := UserInput(78);
end;

procedure TfJapanese.bt79Click(Sender: TObject);

begin
  sUserAnswer := UserInput(79);
end;

procedure TfJapanese.bt80Click(Sender: TObject);

begin
  sUserAnswer := UserInput(80);
end;

{ "Katakana" radio button changes: Enable/Disable " Use extended characters" checkbox }

procedure TfJapanese.rbKatakanaChange(Sender: TObject);

begin
  if rbKatakana.Checked then
    cbExtended.Enabled := True
  else begin
    cbExtended.Checked := False;
    cbExtended.Enabled := False;
  end;
end;

end.

